/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import com.tacz.guns.api.LogicalSide;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.other.KeepingItemRenderer;
import com.tacz.guns.api.event.common.GunDrawEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateMachine;
import com.tacz.guns.client.gameplay.LocalPlayerDataHolder;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.packets.c2s.PlayerDrawGunC2SPacket;
import com.tacz.guns.resource.index.CommonGunIndex;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class LocalPlayerDraw {
    private final LocalPlayerDataHolder data;
    private final class_746 player;

    public LocalPlayerDraw(LocalPlayerDataHolder data, class_746 player) {
        this.data = data;
        this.player = player;
    }

    public void draw(class_1799 lastItem) {
        this.resetData();
        class_1799 currentItem = this.player.method_6047();
        long drawTime = System.currentTimeMillis() - this.data.clientDrawTimestamp;
        IGun currentGun = IGun.getIGunOrNull(currentItem);
        IGun lastGun = IGun.getIGunOrNull(lastItem);
        if (drawTime >= 0L) {
            drawTime = this.getDrawTime(lastItem, lastGun, drawTime);
        }
        long putAwayTime = Math.abs(drawTime);
        if (class_310.method_1551().field_1761 != null) {
            class_310.method_1551().field_1761.method_2911();
        }
        NetworkHandler.sendToServer(new PlayerDrawGunC2SPacket());
        new GunDrawEvent((class_1309)this.player, lastItem, currentItem, LogicalSide.CLIENT).post();
        if (drawTime >= 0L) {
            this.doPutAway(lastItem, lastGun, putAwayTime);
        }
        if (currentGun != null) {
            this.doDraw(currentGun, currentItem, putAwayTime);
        }
    }

    private void doDraw(IGun currentGun, class_1799 currentItem, long putAwayTime) {
        TimelessAPI.getClientGunIndex(currentGun.getGunId(currentItem)).ifPresent(gunIndex -> {
            GunAnimationStateMachine animationStateMachine = gunIndex.getAnimationStateMachine();
            if (animationStateMachine == null) {
                return;
            }
            if (this.data.drawFuture != null) {
                this.data.drawFuture.cancel(false);
            }
            this.data.drawFuture = LocalPlayerDataHolder.SCHEDULED_EXECUTOR_SERVICE.schedule(() -> class_310.method_1551().method_5382(() -> {
                animationStateMachine.onGunDraw();
                SoundPlayManager.stopPlayGunSound();
                SoundPlayManager.playDrawSound((class_1309)this.player, gunIndex);
            }), putAwayTime, TimeUnit.MILLISECONDS);
        });
    }

    private void doPutAway(class_1799 lastItem, IGun lastGun, long putAwayTime) {
        if (lastGun == null) {
            return;
        }
        TimelessAPI.getClientGunIndex(lastGun.getGunId(lastItem)).ifPresent(gunIndex -> {
            SoundPlayManager.stopPlayGunSound();
            SoundPlayManager.playPutAwaySound((class_1309)this.player, gunIndex);
            GunAnimationStateMachine animationStateMachine = gunIndex.getAnimationStateMachine();
            if (animationStateMachine != null) {
                animationStateMachine.onGunPutAway((float)putAwayTime / 1000.0f);
                KeepingItemRenderer.getRenderer().keep(lastItem, putAwayTime);
            }
        });
    }

    private long getDrawTime(class_1799 lastItem, IGun lastGun, long drawTime) {
        if (lastGun != null) {
            Optional<CommonGunIndex> gunIndex = TimelessAPI.getCommonGunIndex(lastGun.getGunId(lastItem));
            float putAwayTime = gunIndex.map(index -> Float.valueOf(index.getGunData().getPutAwayTime())).orElse(Float.valueOf(0.0f)).floatValue();
            if ((float)drawTime > putAwayTime * 1000.0f) {
                drawTime = (long)(putAwayTime * 1000.0f);
            }
            this.data.clientDrawTimestamp = System.currentTimeMillis() + drawTime;
        } else {
            drawTime = 0L;
            this.data.clientDrawTimestamp = System.currentTimeMillis();
        }
        return drawTime;
    }

    private void resetData() {
        this.data.lockState(operator -> operator.getSynDrawCoolDown() > 0L);
        this.data.isShootRecorded = true;
        this.data.clientShootTimestamp = -1L;
        this.data.clientIsAiming = false;
        this.data.clientAimingProgress = 0.0f;
        LocalPlayerDataHolder.oldAimingProgress = 0.0f;
        this.data.isBolting = false;
        if (this.data.clientDrawTimestamp == -1L) {
            this.data.clientDrawTimestamp = System.currentTimeMillis();
        }
    }
}

